#ifndef CUPDATEDIALOG_H
#define CUPDATEDIALOG_H

#include <QDialog>
#include <ui_CUpdateDialog.h>

#include <QMessageBox>
#include <QDirModel>

#include <QrfeCRC>
#include <QrfeTraceModule>
#include <QrfeSleeper>

#include <def.h>

class QrfeReaderInterface;
class QrfeRfeReader;
class QrfeRfeUpdateController;

class FirmwareUpdateManager;


class CUpdateDialog : public QDialog, QrfeTraceModule
{
    Q_OBJECT

public:
	CUpdateDialog(FirmwareUpdateManager* updateManager, QWidget *parent = 0);
	~CUpdateDialog();

public slots:
	int exec(QrfeReaderInterface* ph);
	void tryAccept(bool isBootloader);
	virtual void done ( int r );


	void switch2Firmware();
	void updateReader();

	void setProgress(int cur, int max);

signals:
	void appendGlobalJob(JobType type, const QList<QVariant>& params);

private:
	void loadReaderInformation();
	void loadFirmwareRepository();
	void loadTestFirmwareRepository();
	void loadBootloaderRepository();

private:
	Ui::CUpdateDialogClass ui;

	FirmwareUpdateManager*				m_updateManager;

	QrfeRfeReader* 				m_reader;
	QString 					m_deviceName;
	QrfeGlobal::DeviceType		m_deviceType;
	ulong 						m_bootloaderRevision;
	ulong 						m_softwareRevision;
	ulong						m_hardwareRevision;
	ulong						m_readerType;

	QrfeRfeUpdateController*	m_updateController;

	bool 						m_updateActive;
};

#endif // CUPDATEDIALOG_H
